window.addEventListener('message', function(event) {
    if (event.source !== window) {
        return;
    }
    const message = event.data;
    if (message && message.type === 'CHECK_EXTENSION') {
        chrome.runtime.sendMessage({
            type: 'WEBPAGE_MESSAGE',
            data: message
        });
    }
});
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    if (message.type === 'EXTENSION_RESPONSE') {
        window.postMessage(message, '*');
    }
    return true;
}); 